<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('student_personal', function (Blueprint $table) {
    $table->id();
    $table->unsignedBigInteger('student_id')->index();
    $table->string('civil_id')->unique();
    $table->string('family_name')->nullable();
    $table->string('child_name')->nullable();
    $table->string('nationality')->nullable();
    $table->date('dob')->nullable();
    $table->string('contact_number')->nullable();
    $table->timestamps();

    $table->foreign('student_id')->references('id')->on('students')->onDelete('cascade');
});

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('student_personal');
    }
};
