<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
       Schema::create('student_family', function (Blueprint $table) {
    $table->id();
    $table->unsignedBigInteger('student_id')->index();
    $table->string('father_name')->nullable();
    $table->string('mother_name')->nullable();
    $table->integer('child_no')->nullable();
    $table->integer('number_of_children')->nullable();
    $table->timestamps();

    $table->foreign('student_id')->references('id')->on('students')->onDelete('cascade');
});

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('student_family');
    }
};
