<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
      Schema::create('student_academics', function (Blueprint $table) {
    $table->id();
    $table->unsignedBigInteger('student_id')->index();
    $table->string('school_name')->nullable();
    $table->string('roll_number')->nullable();
    $table->string('class')->nullable();
    $table->string('grades')->nullable();
    $table->decimal('total_fees', 10, 2)->nullable();
    $table->string('fee_type')->nullable();
    $table->timestamps();

    $table->foreign('student_id')->references('id')->on('students')->onDelete('cascade');
});

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('student_academics');
    }
};
