<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
       Schema::create('campaigns', function (Blueprint $table) {
    $table->id();
    $table->string('title'); // Campaign name
    $table->text('description')->nullable(); // Details about the campaign
    $table->date('start_date')->nullable();
    $table->date('end_date')->nullable();
    $table->decimal('goal_amount', 12, 2)->nullable(); // Optional: target amount
    $table->timestamps();
});

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('campaigns');
    }
};
