<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
   public function up()
{
    Schema::table('documents', function (Blueprint $table) {
        $table->unsignedBigInteger('uploaded_by')->nullable()->after('file_path');
        $table->timestamp('verified_at')->nullable()->after('uploaded_by');
        $table->unsignedBigInteger('verified_by')->nullable()->after('verified_at');

        $table->foreign('uploaded_by')->references('id')->on('users')->onDelete('set null');
        $table->foreign('verified_by')->references('id')->on('users')->onDelete('set null');
    });
}

public function down()
{
    Schema::table('documents', function (Blueprint $table) {
        $table->dropForeign(['uploaded_by']);
        $table->dropForeign(['verified_by']);
        $table->dropColumn(['uploaded_by', 'verified_at', 'verified_by']);
    });
}

};
