<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
   public function up()
{
    Schema::table('tasks', function (Blueprint $table) {
        $table->unsignedBigInteger('assigned_to')->nullable()->after('description');
        $table->enum('priority_level', ['low', 'medium', 'high'])->default('medium')->after('assigned_to');
        $table->boolean('is_recurring')->default(false)->after('priority_level');

        $table->foreign('assigned_to')->references('id')->on('users')->onDelete('set null');
    });
}

public function down()
{
    Schema::table('tasks', function (Blueprint $table) {
        $table->dropForeign(['assigned_to']);
        $table->dropColumn(['assigned_to', 'priority_level', 'is_recurring']);
    });
}

};
