<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
       Schema::create('user_login_logs', function (Blueprint $table) {
    $table->id();
    $table->unsignedBigInteger('user_id')->nullable(); // Nullable to log failed login attempts
    $table->string('email')->nullable(); // In case user_id is null
    $table->string('ip_address')->nullable();
    $table->string('user_agent')->nullable(); // Device/browser info
    $table->enum('status', ['success', 'failed'])->default('success');
    $table->text('message')->nullable(); // Optional details (e.g., "Invalid password")
    $table->timestamp('logged_in_at')->useCurrent();
    $table->timestamps();

    $table->foreign('user_id')->references('id')->on('users')->onDelete('set null');
});

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_login_logs');
    }
};
