@php
$route = request()->path();
@endphp

<div class="az-sidebar">
  <div class="az-sidebar-header">
    <a href="{{ url('/') }}" class="az-logo">
      <img class="wd-45 ht-40 mg-l-10 rounded-10" src="{{ url('/img/SEM logo.jpeg') }}">
      <span style="text-transform: uppercase;color: #1d263d;">SEM</span>
    </a>
  </div>

  <div class="az-sidebar-loggedin">
    <div class="az-img-user online">
      <img src="{{ config('user')['profile_img'] ? url('Employee_Image/' . config('user')['profile_img']) : url('img/profile.png') }}" alt="">
    </div>
    <div class="media-body">
      <h6>{{ config('user')['f_name'] ?? 'User' }} {{ config('user')['l_name'] ?? '' }}</h6>
      <span>{{ ucfirst(auth()->user()->role ?? 'User') }}</span>
    </div>
  </div>

  <div class="az-sidebar-body">
    <ul class="nav" id="sidebarMenu">
      <!-- Sidebar items will be injected here -->
    </ul>
  </div>
</div>

<script>
  document.addEventListener('DOMContentLoaded', async function () {
    const sidebar = document.getElementById('sidebarMenu');
    const currentUrl = window.location.pathname;

    try {
      const response = await fetch("{{ url('/api/sidebar') }}", {
        headers: {
          'Authorization': 'Bearer {{ auth()->user()->currentAccessToken()->token ?? '' }}',
          'Accept': 'application/json'
        }
      });

      const items = await response.json();

      items.forEach(item => {
        const isActive = currentUrl === item.route ? 'active show' : '';
        const li = document.createElement('li');
        li.className = `nav-item ${isActive}`;
        li.innerHTML = `
          <a href="${item.route}" class="nav-link">
            <i class="${item.icon}" style="font-size: 16px;"></i>
            ${item.name}
          </a>
        `;
        sidebar.appendChild(li);
      });
    } catch (error) {
      console.error('Sidebar load failed', error);
      sidebar.innerHTML = `<li class="nav-item"><a class="nav-link text-danger">Sidebar error</a></li>`;
    }
  });
</script>
