<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use  App\Http\Controllers\API\{AuthController, StudentController, DonorController, DocumentController, TaskController, DonationController, ReportController,CampaignController};

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/


Route::post('/login', [AuthController::class, 'login']);

Route::middleware('auth:sanctum')->group(function () {
    Route::post('/logout', [AuthController::class, 'logout']);
});

Route::middleware(['auth:sanctum'])->group(function () {
     //student
     
    Route::get('students', [StudentController::class, 'index'])->name('students.index');
    Route::post('students/store', [StudentController::class, 'store']);
    //Route::get('students/{id}', [StudentController::class, 'show'])->name('students.show');
    Route::post('students/update/{id}', [StudentController::class, 'update']);
    Route::delete('students/delete/{id}', [StudentController::class, 'destroy']);
   Route::post('students/{id}/upload-document', [StudentController::class, 'uploadDocument']);
    Route::get('students/auto-upgrade', [StudentController::class, 'autoUpgrade']);


   Route::prefix('donors')->group(function () {
    Route::get('/', [DonorController::class, 'index']);
    Route::post('store', [DonorController::class, 'store']);
    Route::get('{id}', [DonorController::class, 'show']);
    Route::post('update/{id}', [DonorController::class, 'update']);
    Route::delete('delete/{id}', [DonorController::class, 'destroy']);
});
    Route::apiResource('donations', DonationController::class);
    Route::apiResource('documents', DocumentController::class);
    Route::apiResource('tasks', TaskController::class);
    
    Route::get('/reports/donor/{id}', [ReportController::class, 'donorReport']);
    Route::get('/reports/students', [ReportController::class, 'studentUpgradeReport']);

    Route::get('/campaigns', [CampaignController::class, 'index']);
Route::post('/campaigns', [CampaignController::class, 'store']);
Route::post('/campaigns/{id}', [CampaignController::class, 'update']);
Route::delete('campaigns/{id}', [CampaignController::class, 'destroy']);

});






